

Type TRectangleBrush
	Field _borderColor:TColor
	Field _color:TColor
	Field _layer:Float
	Field _width:Int
	Field _height:Int
	Field _texture:TImage
	
	Method GetColor:TColor() 
		Return _color
	End Method
	
	Method SetColor(value:TColor) 
		_color = value
	End Method
	
	
	Method GetLayer:Float() 
		Return _layer
	End Method
	
	Method SetLayer(value:Float) 
		_layer = value
	End Method
	
	Method GetBorderColor:TColor() 
		Return _borderColor
	End Method
	
	Method SetBorderColor(value:TColor) 
		_borderColor = value.Copy() 
	End Method
	
	Method GetWidth:Int() 
		Return _width
	End Method
	
	Method GetHeight:Int() 
		Return _height
	End Method
	
	Method SetWidth(value:Int) 
		_width = value
	End Method
	
	Method SetHeight(value:Int) 
		_height = value
	End Method
	
	Function Create:TRectangleBrush(width:Int, height:Int, color:TColor, borderColor:TColor) 
		Local r:TRectangleBrush = New TRectangleBrush
		r._width = width
		r._height = height
		r._color = color
		r._borderColor = borderColor
		r._texture = TDrawingHelper.CreateRectangleTexture(width, height, color, borderColor) 
		MidHandleImage(r._texture) 
		Return r
	End Function
	
	Method Draw(position:Vector2) 
		DrawImage(_texture, position.X, position.Y) 
	End Method
End Type
